<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade for vBulletin                                          # ||
|| # Support: http://www.v3arcade.com                                 # ||
|| # Copyright: http://www.cinvin.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

// Returns number of rounds in the tournament.
// Returns false if not a correct number of players submitted
function fetch_num_rounds($numplayers)
{
	if ($numplayers == 2)
	{
		return	1;
	}
	if ($numplayers == 4)
	{
		return	2;
	}
	if ($numplayers == 8)
	{
		return	3;
	}
	if ($numplayers == 16)
	{
		return	4;
	}

	return 0;
}

// Compares all the results in the current round of the submitted tournament.
// $tournament variabel should have all columns from the arcade_tournaments table.
function compare_allscores($tournament)
{
	global $db;

	$slotsresult = $db->query_read("
		SELECT arcade_tournamentplayers.*, user.arcadeoptions, user.email, user.username
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid=arcade_tournamentplayers.userid)
		WHERE round = $tournament[round]
			AND tid = $tournament[tid]
		ORDER BY slot ASC
	");
	if ($slotsresult)
	{
		$slots = array();
		while ($slot = $db->fetch_array($slotsresult))
		{
			$slots[$slot['slot']] = $slot;
		}
	}

	$db->free_result($slotsresult);

	foreach($slots as $slot)
	{
		if (!($slot['slot'] % 2))
		{
			compare_slots($tournament, $slot, $slots, true);
		}
	}
}

// Compares one slot with its competition and declare a winner.
// Returns false if no result can be decided. -1 if $player lost. +1 if $player won.
function compare_slots($tournament, $player, $slots, $notifyboth = false)
{
  global $db, $vbulletin, $vbphrase;

  // Get which slot we should compare results with.
	$cmpslot = ($player['slot'] % 2) ? $player['slot'] - 1 : $player['slot'] + 1;

	// Check that both slots is filled, that none is still playing and that none already has a winner status
	if (!$player['userid'] OR !$slots[$cmpslot]['userid'] OR $player['playing'] == 1 OR $slots[$cmpslot]['playing'] == 1 OR $player['status'] >= 20 OR $slots[$cmpslot]['status'] >= 20)
  {
  	return false;
  }

	// Extra saftey check that it's the same round, and not the last one
	if ($player['round'] != $tournament['round'] OR $slots[$cmpslot]['round'] != $tournament['round'] OR !$tournament['round'])
	{
		return false;
	}

	// First check if anyone is disquallified
	if ($player['status'] == 11)
	{
		$winnerslot = $slots[$cmpslot];
		$loserslot = $player;
		$winnerslot['status'] = 21; // Set winner status to 21 (Win by disq)

		// This hook is when a matchup is decided because one player was disqualified.
		($hook = vBulletinHook::fetch_hook('arcadetourmnt_winbydisq')) ? eval($hook) : false;
	}
	else
	{
		if ($slots[$cmpslot]['status'] == 11)
		{
			$winnerslot = $player;
			$loserslot = $slots[$cmpslot];
			$winnerslot['status'] = 21; // Set winner status to 21 (Win by disq)

			// This hook is when a matchup is decided because one player was disqualified.
			($hook = vBulletinHook::fetch_hook('arcadetourmnt_winbydisq')) ? eval($hook) : false;
		}
		else
		{
			// None disquallified, continue with checking scores. Has both players played all their games?
			if ($player['tries'] < $tournament['numtries'] OR $slots[$cmpslot]['tries'] < $tournament['numtries'])
			{
				return false; // No, then we are done.
			}

			if ($player['score'] === $slots[$cmpslot]['score'])
			{
				// Same score, give each player another try and send them a notification
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
						tries = tries-1,
						score = 0
					WHERE tpid = $player[tpid]
						OR tpid = " . $slots[$cmpslot]['tpid']
				);

				// This hook is when a matchup is decided but we haven't got a winner (or looser). Their score was the same.
				($hook = vBulletinHook::fetch_hook('arcadetourmnt_samescore')) ? eval($hook) : false;

				if ($player['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
				{
					vbmail($player['email'],
						construct_phrase($vbphrase['tournament_notification'], $tournament['title']),
						construct_phrase(
							$vbphrase['tournament_notification_equal_email'],
							$player['username'],
							$tournament['title'],
							$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
							$tournament['username']
						),
						false
					);
				}

				if ($slots[$cmpslot]['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
				{
					vbmail($slots[$cmpslot]['email'],
						construct_phrase($vbphrase['tournament_notification'], $tournament['title']),
						construct_phrase(
							$vbphrase['tournament_notification_equal_email'],
							$slots[$cmpslot]['username'],
							$tournament['title'],
							$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
							$tournament['username']
						),
						false
					);
				}

				if ($player['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
				{
					$senderpermissions['adminpermissions'] = 2;

					$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
					$pmdm->set('fromuserid', $tournament['creator']);
					$pmdm->set('fromusername', $tournament['username']);
					$pmdm->set('title', construct_phrase($vbphrase['tournament_notification'], $tournament['title']));
					$pmdm->set('message', construct_phrase(
						$vbphrase['tournament_notification_equal_pm'],
						$player['username'],
						$tournament['title'],
						$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
						$tournament['username']
					));
					$pmdm->set_recipients($player['username'], $senderpermissions);
					$pmdm->set('dateline', TIMENOW);

					if (empty($pmdm->errors)) $pmdm->save();
				}

				if ($slots[$cmpslot]['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
				{
					$senderpermissions['adminpermissions'] = 2;

					$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
					$pmdm->set('fromuserid', $tournament['creator']);
					$pmdm->set('fromusername', $tournament['username']);
					$pmdm->set('title', construct_phrase($vbphrase['tournament_notification'], $tournament['title']));
					$pmdm->set('message', construct_phrase(
						$vbphrase['tournament_notification_equal_pm'],
						$slots[$cmpslot]['username'],
						$tournament['title'],
						$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
						$tournament['username']
					));
					$pmdm->set_recipients($slots[$cmpslot]['username'], $senderpermissions);
					$pmdm->set('dateline', TIMENOW);
					$pmdm->save();
				}

				// We haven't got a winner
				return false;
			}
			else
			{
				if (!isset($player['score']))
				{
					$winnerslot = $slots[$cmpslot];
					$loserslot = $player;
				}
				else
				{
					if (!isset($slots[$cmpslot]['score']))
					{
						$winnerslot = $player;
						$loserslot = $slots[$cmpslot];
					}
					else
					{
						if ($player['score'] > $slots[$cmpslot]['score'])
						{
							$winnerslot = ($tournament['isreverse'] == 1) ? $slots[$cmpslot] : $player;
							$loserslot = ($tournament['isreverse'] == 1) ? $player : $slots[$cmpslot];
						}
						else
						{
							$winnerslot = ($tournament['isreverse'] == 1) ? $player : $slots[$cmpslot];
							$loserslot = ($tournament['isreverse'] == 1) ? $slots[$cmpslot] : $player;
						}
					}
				}

				$winnerslot['status'] = 20; // Set winner status to 20 (Win by score)
				$loserslot['status'] = 10; // Set loser status to 10 (Lost by score)

				// This hook is when a matchup is decided and we got a winner (and looser) by score.
				($hook = vBulletinHook::fetch_hook('arcadetourmnt_cmpscoredone')) ? eval($hook) : false;
			}
		}
	}

	// We got a winner! (and a loser) Update their status in the database
  $db->query_write("
  	UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
  		status = '$winnerslot[status]'
  	WHERE tpid = '$winnerslot[tpid]'
  ");

	if ($loserslot['status'] != 11)
	{
		// Loser don't need a update if it's by disq.
	  $db->query_write("
	  	UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
	  		status = '$loserslot[status]'
	  	WHERE tpid = '$loserslot[tpid]'
	  ");
	}

	$newround = $tournament['round'] - 1;
	// Create a new slot for the winner in the next round
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "v3arcade_tournamentplayers
			(tid, userid, datestamp, tries, round, slot, status)
		VALUES (
			$tournament[tid],
			$winnerslot[userid],
			$winnerslot[datestamp],
			0,
			$newround,
			" . floor($winnerslot['slot'] / 2) . ",
			" . (!$newround ? 30 : 0) . "
	)");

	// Check if all results are in and we can begin the next round
	$slots[$winnerslot['slot']] = $winnerslot;
	$slots[$loserslot['slot']] = $loserslot;

	foreach ($slots as $slot)
	{
		if ($slot['status'] < 10)
		{
			$resultmissing = true;
		}
	}

	if (!$resultmissing)
	{
		// We got all the results, update the tournament database
		if (!$newround)
		{
			$winner = $winnerslot['userid'];

			if ($vbulletin->options['tourmntEnableCosts'] AND $tournament['joincost'])
			{
				// If join cost enabled set some variables for easy integration.
				$tournament_winneruserid = $winner['userid'];
				$tournament_winnerprize = $tournament['joincost'] * $tournament['numplayers'];
			}

			// This hook is when the tournament is over and we have a winner
			($hook = vBulletinHook::fetch_hook('arcadetourmnt_finished')) ? eval($hook) : false;

			if ($vbulletin->options['tourmntaddnews'] & $vbulletin->bf_misc_arcadetourmnt_addnews['arcadetourmnt_addnews_finished'])
			{
				insert_arcade_news(construct_phrase(
					$vbphrase['news_tournament_finished'],
					$tournament['title'],
					$winnerslot['username']
				));
			}

			// Reload the slots array, so it includes all the players that joined the tournament.
			// This is so we can notify all players that the tournament is finished.
			$firstround = fetch_num_rounds($tournament['numplayers']);
			if ($firstround)
			{
				$slotsresult = $db->query_read("
					SELECT arcade_tournamentplayers.*, user.arcadeoptions, user.email, user.username
					FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
					WHERE round = $firstround
						AND tid = $tournament[tid]
					ORDER BY slot ASC
				");
				if ($slotsresult)
				{
					$slots = array();
					while ($slot = $db->fetch_array($slotsresult))
					{
						$slots[$slot['slot']] = $slot;
					}
				}
			}
		}

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournaments SET
				round = $newround,
				roundstart = " . TIMENOW .
				iif ($winner, ", winner = '$winner', status = 2") . "
			WHERE tid = $tournament[tid]
		");

		// Update the cache if the status changed
		if ($winner)
		{
			build_tournament_cache();
		}

		// Notify all the players that they are either out or a new round is about to start or if the tournament is over and in that case, who won
		vbmail_start();
		foreach($slots as $slot)
		{
			if ($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['tournamentsevents'])
			{
				// Use a different message, depanding...
				$msgphrase = false;
				if (!$newround)
				{
					if ($slot['userid'] == $winner)
					{
						$msgphrase = 'tournament_notification_champion';
						if (isset($tournament_winnerprize) AND $tournament_winnerprize > 0)
						{
							$msgphrase .= '_prize';
						}
					}
					else
					{
						$msgphrase = 'tournament_notification_finished';
					}
				}
				else
				{
					if ($slot['status'] >= 10 AND $slot['status'] < 20)
					{
						$msgphrase = 'tournament_notification_lost';
					}
					else if ($slot['status'] >= 20 AND $slot['status'] < 30)
					{
						$msgphrase = 'tournament_notification_won';
					}
				}

				if ($msgphrase)
				{
					if ($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
					{
						vbmail($slot['email'],
							construct_phrase($vbphrase['tournament_notification'], $tournament['title']),
							construct_phrase(
								$vbphrase[$msgphrase . '_email'],
								$slot['username'],
								$tournament['title'],
								$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
								$tournament['username'],
								$winnerslot['username'],
								$tournament_winnerprize
							),
							false
						);
					}

					if ($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
					{
						$senderpermissions['adminpermissions'] = 2;

						$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
						$pmdm->set('fromuserid', $tournament[creator]);
						$pmdm->set('fromusername', $tournament[username]);
						$pmdm->set('title', construct_phrase($vbphrase['tournament_notification'], $tournament['title']));
						$pmdm->set('message', construct_phrase(
							$vbphrase[$msgphrase . '_pm'],
							$slot['username'],
							$tournament['title'],
							$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
							$tournament['username'],
							$winnerslot['username'],
							$tournament_winnerprize
						));
						$pmdm->set_recipients($slot['username'], $senderpermissions);
						$pmdm->set('dateline', TIMENOW);

						if (empty($pmdm->errors)) $pmdm->save();
					}
				}
			}
		}
		vbmail_end();
	}

	if ($winnerslot['slot'] == $player['slot'])
	{
		return 1;
	}

	return -1;
}

// ##### Send Tournament Invite ###############################################
function send_tournament_invite($sendto)
{
	global $vbulletin, $db, $vbphrase, $game, $title, $tid;
	
	if (is_array($sendto))
	{
		$sendto = implode(', ', $sendto);
	}
	else
	{
		$sendto = intval($sendto);
	}

	if (!$sendto)
	{
		return false;
	}

	$senderpermissions['adminpermissions'] = 2;

	$sendinviteto = '';
	$getbuddies = $db->query_read("
		SELECT user.username, usertf.ignorelist
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertf ON (user.userid = usertf.userid)
		WHERE user.userid IN($sendto)
	");
	while ($buddy = $db->fetch_array($getbuddies))
	{
		// sender is on buddy's ignore list
		if ($buddy['ignorelist'] AND in_array($vbulletin->userinfo['userid'], explode(' ', $buddy['ignorelist'])))
		{
			continue;
		}

		$sendinviteto .= $buddy['username'] . ';';
	}

	if ($sendinviteto)
	{
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set_info('is_automated', true);
		$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
		$pmdm->set('fromusername', $vbulletin->userinfo['username']);
		$pmdm->set('title', construct_phrase($vbphrase['notify_tournament_invite_title'], $game['title']));
		$pmdm->set('message', construct_phrase($vbphrase['notify_tournament_invite_message'], $vbulletin->userinfo['username'], $game['title'], $title, $vbulletin->options['bburl'], $tid));
		$pmdm->set_recipients(substr($sendinviteto, 0, -1), $senderpermissions);
		$pmdm->set('dateline', TIMENOW);

		$pmdm->save();

		return true;
	}

	// not sent to any members
	return false;	
}

?>
